// ConfigureGroupTZ.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ConfigureGroupTZ.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigureGroupTZ dialog


CConfigureGroupTZ::CConfigureGroupTZ(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigureGroupTZ::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigureGroupTZ)
	m_ExistTZ = _T("");
	m_AccountName = _T("");
	m_GroupName = _T("");
	m_ExistingTimezoneName = _T("");
	m_TimezoneName = _T("");
	m_PanelName = _T("");
	//}}AFX_DATA_INIT
}

CConfigureGroupTZ ::CConfigureGroupTZ(IApplication *pApp):CDialog(CConfigureGroupTZ::IDD, NULL)
{
	pApplication = pApp;
}
void CConfigureGroupTZ::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
//	UpdateData(FALSE);
//	m_AcctList.SetCurSel(0);
}
void CConfigureGroupTZ::LoadPanels()
{
	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index,sAcctName);
	_variant_t vPanels;
	vPanels.Clear();
	long lAccountID = _wtoi(sAcctName);
	pApplication->GetPanelsByAcctID(lAccountID,&vPanels);
	if(vPanels.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Panels");
			return;
	}
		
		long uBound =0 ;
		IHWDevice *pPanels =NULL;
		COleSafeArray sa(vPanels);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		//BSTR bstrPanel;
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pPanels);
			if (pPanels != NULL)
			{	
				CString sPanelid;
				sPanelid.Format(L"%ld",pPanels->HWDeviceID);
				m_PanelList.AddString(sPanelid);	
				pPanels->Release();
			}
			pDisp->Release();
		}
}
void CConfigureGroupTZ::LoadGroups()
{
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(indexaccount,sAcctName);
	long lAccountID = _wtoi(sAcctName);
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	m_PanelList.GetLBText(indexpanel,sPanelID);
	_variant_t vGroups;
	vGroups.Clear();
	long lPanelID = _wtoi(sPanelID);
	pApplication->GetGroupsByPanelID(lAccountID,lPanelID,&vGroups);
	if(vGroups.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Groups");
			return;
	}
		
		long uBound =0 ;
		IHWDevice *pGroups =NULL;
		COleSafeArray sa(vGroups);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		//BSTR bstrPanel;
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pGroups);
			if (pGroups != NULL)
			{	
				CString sGroupid;
				sGroupid.Format(L"%ld",pGroups->DeviceID);
				m_Groups.AddString(sGroupid);	
				pGroups->Release();
			}
			pDisp->Release();
		}
}
void CConfigureGroupTZ::LoadPanelTimezones()
{
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(indexaccount,sAcctName);
	long lAccountID = _wtoi(sAcctName);
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	m_PanelList.GetLBText(indexpanel,sPanelID);
	_variant_t vTimeZones;
	vTimeZones.Clear();
	long lPanelID = _wtoi(sPanelID);
	pApplication->GetAvailableTimezonesOfPanel(lAccountID,lPanelID,&vTimeZones);
	if(vTimeZones.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Timezone");
			return;
	}
	

		int none = 0;
		CString sNone;
		sNone.Format(L"%d", none);
		m_Timezones.AddString(sNone);
		long uBound =0 ;
		ITimeZone *pTimeZones =NULL;
		COleSafeArray sa(vTimeZones);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		//BSTR bstrPanel;
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTimeZones);
			if (pTimeZones != NULL)
			{	
				CString sTimezoneid;
				sTimezoneid.Format(L"%ld",pTimeZones->TimeZoneID);
				m_Timezones.AddString(sTimezoneid);	
				pTimeZones->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}
void CConfigureGroupTZ::GetExistingTimezone()
{
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(indexaccount,sAcctName);
	long lAccountID = _wtoi(sAcctName);


	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	m_PanelList.GetLBText(indexpanel,sPanelID);
	long lPanelID = _wtoi(sPanelID);


	int indexgroup = m_Groups.GetCurSel();
	CString sGroupID;
	m_Groups.GetLBText(indexgroup,sGroupID);
	long lGroupID = _wtoi(sGroupID);

	_variant_t vTimeZone;
	vTimeZone.Clear();
	pApplication->GetAssociatedTimezoneOfGroup(lAccountID,lPanelID,lGroupID,&vTimeZone);
	if(vTimeZone.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vTimeZone.vt & VT_DISPATCH)
		{
			ITimeZonePtr pTz(vTimeZone.pdispVal);
			long lTimezoneID = pTz->TimeZoneID;
			CString sTimezoneid;
			BSTR pBstrTimezoneName;
			sTimezoneid.Format(L"%ld",lTimezoneID);
			m_ExistTZ = sTimezoneid;
			pApplication->GetTimezoneNameByID(lTimezoneID,&pBstrTimezoneName);
			m_ExistingTimezoneName = CString(pBstrTimezoneName);	
			if(lTimezoneID==0)
			{
				m_ExistingTimezoneName = "None";
			}
			
		}
		UpdateData(FALSE);

		if(NULL != vTimeZone.pdispVal)
		{
			//vTz.pdispVal->Release();
			vTimeZone.Clear();
		}
	
}
void CConfigureGroupTZ::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigureGroupTZ)
	DDX_Control(pDX, IDC_TIMEZONES, m_Timezones);
	DDX_Control(pDX, IDC_GROUPS, m_Groups);
	DDX_Control(pDX, IDC_PANELLIST, m_PanelList);
	DDX_Control(pDX, IDC_ACCOUNTLIST, m_AcctList);
	DDX_Text(pDX, IDC_EXISTINGTIMEZONE, m_ExistTZ);
	DDX_Text(pDX, IDC_ACCOUNTNAME, m_AccountName);
	DDX_Text(pDX, IDC_GROUPNAME, m_GroupName);
	DDX_Text(pDX, IDC_EXISTINGTIMEZONENAME, m_ExistingTimezoneName);
	DDX_Text(pDX, IDC_TIMEZONENAME, m_TimezoneName);
	DDX_Text(pDX, IDC_PANELNAME, m_PanelName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigureGroupTZ, CDialog)
	//{{AFX_MSG_MAP(CConfigureGroupTZ)
	ON_CBN_SELCHANGE(IDC_ACCOUNTLIST, OnSelchangeAccountlist)
	ON_CBN_SELCHANGE(IDC_PANELLIST, OnSelchangePanellist)
	ON_BN_CLICKED(IDC_CONFIGURE, OnConfigure)
	ON_CBN_SELCHANGE(IDC_GROUPS, OnSelchangeGroups)
	ON_CBN_SELCHANGE(IDC_TIMEZONES, OnSelchangeTimezones)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigureGroupTZ message handlers

void CConfigureGroupTZ::OnSelchangeAccountlist() 
{
	m_PanelList.ResetContent();
	m_Timezones.ResetContent();
	m_Groups.ResetContent();
	LoadPanels();	
	CString sAcctName;
	BSTR pBstrAcctName;
	long lAccountID;
	int indexaccount = 0;
	indexaccount = m_AcctList.GetCurSel();
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}
	pApplication->GetAccountNameByAcctID(lAccountID,&pBstrAcctName);
	UpdateData(TRUE);
	m_AccountName = CString(pBstrAcctName);
	UpdateData(FALSE);
}

void CConfigureGroupTZ::OnSelchangePanellist() 
{
	m_Groups.ResetContent();
	LoadGroups();
	m_Timezones.ResetContent();
	LoadPanelTimezones();	
		BSTR pBstrDeviceName;
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	long lHWDeviceID;
	if(indexpanel<0)
	{
		lHWDeviceID = 0;
	}
	else
	{
		m_PanelList.GetLBText(indexpanel,sPanelID);
		lHWDeviceID = _wtoi(sPanelID);
	}
	pApplication->GetDeviceNameByHWDeviceID(lHWDeviceID,&pBstrDeviceName);
	UpdateData(TRUE);
	m_PanelName = CString(pBstrDeviceName);
	UpdateData(FALSE);
}

BOOL CConfigureGroupTZ::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigureGroupTZ::OnConfigure() 
{
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	long lAccountID;
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}

	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	long lPanelID;
	if(indexpanel<0)
	{
		lPanelID = 0;
	}
	else
	{
		m_PanelList.GetLBText(indexpanel,sPanelID);
		lPanelID =_wtoi(sPanelID);
	}


	int indexgroup= m_Groups.GetCurSel();
	CString sGroupID;
	long lGroupID = 0;
	if(indexgroup<0)
	{
		lGroupID = 0;
	}
	else
	{
		m_Groups.GetLBText(indexgroup,sGroupID);
		lGroupID = _wtoi(sGroupID);
	}
	
	int indextimezone = m_Timezones.GetCurSel();
	CString sTimezoneID;
	long lTimezoneID =0;
	if(indextimezone<0)
	{
		lTimezoneID= -1;
	}
	else
	{
		m_Timezones.GetLBText(indextimezone,sTimezoneID);
		lTimezoneID = _wtoi(sTimezoneID);
	}

	long lStatus =0;
	pApplication->ConfigureGroupTimezone(lAccountID,lPanelID,lGroupID,lTimezoneID,&lStatus);	
	if ( lStatus == 0)
	{
		AfxMessageBox(L"Timezone configured Successfully");
		CDialog::OnOK();
	}
	if (lStatus ==1)
	{
		AfxMessageBox(L"Timezone configuration failed");
		CDialog::OnOK();
	}
	if (lStatus == 105)
	{
		AfxMessageBox(L"Invalid account");
		return;
	}
	if (lStatus == 501)
	{
		AfxMessageBox(L"Invalid panel");
		return;
	}
	if (lStatus == 503)
	{
		AfxMessageBox(L"Invalid group");
		return;
	}
	if (lStatus == 504)
	{
		AfxMessageBox(L"Invalid timezone");
		return;
	}
	if (lStatus == 505)
	{
		AfxMessageBox(L"Groups Option is not checked in WPCS UI or the Group is not made active");
		return;
	}
}

void CConfigureGroupTZ::OnSelchangeGroups() 
{
	BSTR pBstrDeviceName;
	int indexgroup = m_Groups.GetCurSel();
	CString sGroupID;
	long lDeviceID;
	if(indexgroup<0)
	{
		lDeviceID = 0;
	}
	else
	{
		m_Groups.GetLBText(indexgroup,sGroupID);
		lDeviceID = _wtoi(sGroupID);
	}
	pApplication->GetDevNameByDeviceID(lDeviceID,&pBstrDeviceName);
	UpdateData(TRUE);
	m_GroupName = CString(pBstrDeviceName);
	UpdateData(FALSE);
	m_ExistTZ = _T("0");
	// For the UI Update Issue on the None TZ -- Guru
	m_ExistingTimezoneName =_T("None");
	UpdateData(FALSE);
	GetExistingTimezone();	
}

void CConfigureGroupTZ::OnSelchangeTimezones() 
{
	BSTR pBstrTimezoneName;
	int indextimezone = m_Timezones.GetCurSel();
	CString sTimezoneID;
	long lTimezoneID;
	if(indextimezone<0)
	{
		lTimezoneID= 0;
	}
	else
	{
		m_Timezones.GetLBText(indextimezone,sTimezoneID);
		lTimezoneID = _wtoi(sTimezoneID);
	}
	pApplication->GetTimezoneNameByID(lTimezoneID,&pBstrTimezoneName);
	UpdateData(TRUE);
	if(lTimezoneID==0)
	{
		pBstrTimezoneName = SysAllocString(L"None");
	}
	m_TimezoneName = CString(pBstrTimezoneName);
	UpdateData(FALSE);	
}
